/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.block.component;

import com.mojang.math.Vector3f;
import com.technicalitiesmc.lib.block.BlockComponent;
import com.technicalitiesmc.lib.block.ScrollingHandler;
import com.technicalitiesmc.lib.init.TKLibItemTags;
import com.technicalitiesmc.lib.init.TKLibSoundEvents;
import com.technicalitiesmc.lib.network.TKLibNetworkHandler;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class BlockScrollRotation
extends BlockComponent.WithoutData
implements ScrollingHandler {
    private static final long ROTATION_DELAY = 1L;
    private static final DustParticleOptions ROTATION_PARTICLE_OPTIONS = new DustParticleOptions(new Vector3f(0.8f, 0.8f, 0.8f), 0.5f);
    private static final DustParticleOptions ROTATION_PARTICLE_OPTIONS_DARK = new DustParticleOptions(new Vector3f(0.2f, 0.2f, 0.2f), 0.5f);
    private final boolean requiresCrouching;
    private final TagKey<Item> itemTag;
    private long lastRotation = 0L;

    private BlockScrollRotation(BlockComponent.Context context, boolean requiresCrouching, TagKey<Item> itemTag) {
        super(context);
        this.requiresCrouching = requiresCrouching;
        this.itemTag = itemTag;
    }

    public static BlockComponent.Constructor<BlockScrollRotation> of(boolean requiresCrouching, TagKey<Item> itemTag) {
        return ctx -> new BlockScrollRotation(ctx, requiresCrouching, itemTag);
    }

    public static BlockComponent.Constructor<BlockScrollRotation> of() {
        return BlockScrollRotation.of(true, TKLibItemTags.TOOLS_WRENCH);
    }

    @Override
    @Nullable
    protected Object getInterface(Class<?> itf) {
        if (itf == ScrollingHandler.class) {
            return this;
        }
        return super.getInterface(itf);
    }

    @Override
    public boolean scroll(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit, double scrollDelta) {
        long now = level.m_46467_();
        if (now < this.lastRotation + 1L) {
            return true;
        }
        if ((!this.requiresCrouching || player.m_6144_()) && player.m_21205_().m_204117_(this.itemTag)) {
            Direction.Axis axis = hit.m_82434_().m_122434_();
            boolean axisPositive = hit.m_82434_().m_122421_() == Direction.AxisDirection.POSITIVE;
            Rotation rotation = scrollDelta > 0.0 != axisPositive ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90;
            this.lastRotation = now;
            TKLibNetworkHandler.sendServerboundRotateBlock(pos, axis, rotation);
            if (this.getBlock().rotate(state, level, pos, axis, rotation)) {
                float d = -Math.signum((float)scrollDelta) * 0.05f;
                level.m_5594_(player, pos, (SoundEvent)TKLibSoundEvents.WRENCH.get(), SoundSource.PLAYERS, 0.45f, 0.95f + (float)Math.random() * 0.1f + d);
                this.spawnParticles(level, pos, ROTATION_PARTICLE_OPTIONS);
            } else {
                level.m_5594_(player, pos, SoundEvents.f_12449_, SoundSource.PLAYERS, 0.4f, 0.9f);
                level.m_5594_(player, pos, SoundEvents.f_12449_, SoundSource.PLAYERS, 0.4f, 1.0f);
                this.spawnParticles(level, pos, ROTATION_PARTICLE_OPTIONS_DARK);
            }
            return true;
        }
        return false;
    }

    private void spawnParticles(Level level, BlockPos pos, DustParticleOptions options) {
        int res = 6;
        for (int x = 0; x <= res; ++x) {
            boolean xFace = x == 0 || x == res;
            for (int y = 0; y <= res; ++y) {
                boolean yFace = y == 0 || y == res;
                for (int z = 0; z <= res; ++z) {
                    boolean zFace;
                    if ((xFace ? 1 : 0) + (yFace ? 1 : 0) + ((zFace = z == 0 || z == res) ? 1 : 0) < 2) continue;
                    level.m_7106_((ParticleOptions)options, (double)((float)pos.m_123341_() + (float)x / (float)res), (double)((float)pos.m_123342_() + (float)y / (float)res), (double)((float)pos.m_123343_() + (float)z / (float)res), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

